/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.thonkutil.api.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.TreeMap;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_1928;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;

public abstract class ThonkUtilLanguageProvider
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final FabricDataGenerator fabricDataGenerator;
    private final String locale;
    private final TreeMap<String, String> data = new TreeMap();

    public ThonkUtilLanguageProvider(FabricDataGenerator fabricDataGenerator, String locale) {
        this.fabricDataGenerator = fabricDataGenerator;
        this.locale = locale;
    }

    protected String getLocale() {
        return this.locale;
    }

    protected String getModId() {
        return this.fabricDataGenerator.getModId();
    }

    public void method_10319(class_2408 cache) throws IOException {
        this.addTranslations();
        String rawJson = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)GSON.toJson(this.data));
        Path path = this.fabricDataGenerator.method_10313().resolve("assets/" + this.fabricDataGenerator.getModId() + "/lang/" + this.locale + ".json");
        boolean debug = false;
        if (debug) {
            System.out.println("JSON: " + rawJson);
            System.out.println("Path: " + path);
        }
        String hash = field_11280.hashUnencodedChars((CharSequence)rawJson).toString();
        if (!Objects.equals(cache.method_10323(path), hash) || !Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(rawJson);
            }
        }
        cache.method_10325(path, hash);
    }

    public String method_10321() {
        return null;
    }

    protected abstract void addTranslations();

    public void add(class_2248 key, String name) {
        this.add(key.method_9539(), name);
    }

    public void add(class_1792 key, String name) {
        this.add(key.method_7876(), name);
    }

    public void add(class_1799 key, String name) {
        this.add(key.method_7922(), name);
    }

    public void add(class_1887 key, String name) {
        this.add(key.method_8184(), name);
    }

    public void add(class_1291 key, String name) {
        this.add(key.method_5567(), name);
    }

    public void add(class_1299<?> key, String name) {
        this.add(key.method_5882(), name);
    }

    public void add(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    public void add(class_1928.class_4313<?> gameruleId, String translation) {
        this.add(gameruleId.method_27334(), translation);
    }

    public void addPotionSet(class_1842 potion, String translation) {
        this.add("item.minecraft.potion.effect." + this.getPotion0(potion), "Potion of " + translation);
        this.add("item.minecraft.splash_potion.effect." + this.getPotion0(potion), "Splash Potion of " + translation);
        this.add("item.minecraft.tipped_arrow.effect." + class_2378.field_11143.method_10221((Object)potion).method_12832(), "Arrow of " + translation);
    }

    public void addAutoConfigTitle(String translation) {
        this.addMisc("title", translation, "text.autoconfig");
    }

    public void addAutoConfigCategory(String categoryId, String translation) {
        String part1 = categoryId.split(":").length == 2 ? categoryId.split(":")[0] : this.fabricDataGenerator.getModId();
        String part2 = categoryId.split(":").length == 2 ? categoryId.split(":")[1] : categoryId;
        this.add("text.autoconfig." + part1 + ".category." + part2, translation);
    }

    public void addAutoConfigOption(String optionId, String translation) {
        String part1 = optionId.split(":").length == 2 ? optionId.split(":")[0] : this.fabricDataGenerator.getModId();
        String part2 = optionId.split(":").length == 2 ? optionId.split(":")[1] : optionId;
        this.add("text.autoconfig." + part1 + ".option." + part2, translation);
    }

    public void addRequiemTooltip(String tooltipId, String translation) {
        String part1 = tooltipId.split(":").length == 2 ? tooltipId.split(":")[0] : this.fabricDataGenerator.getModId();
        String part2 = tooltipId.split(":").length == 2 ? tooltipId.split(":")[1] : tooltipId;
        this.add(part1 + ":tooltip." + part2, translation);
    }

    private void addMisc(String id, String translation, String miscId) {
        if (id.split(":").length == 2) {
            this.add(miscId + "." + id.split(":")[0] + "." + id.split(":")[1], translation);
            return;
        }
        this.add(miscId + "." + this.fabricDataGenerator.getModId() + "." + id, translation);
    }

    private String getPotion0(class_1842 potion) {
        return potion.field_8954 == null ? class_2378.field_11143.method_10221((Object)potion).method_12832() : potion.field_8954;
    }
}

